;klawiatura 
;XX - nr kodu (od 00 - 25) 00 - nr kodu instalatora
;xxxx - 4 cyfry kodu - otwarcie
;0# - uzbrojenie
;00 2544 (instalator) * - 3 ostatnie nr kodw rozbrajajce OD OSTATNEGO
;00 2544 (instalator) # 01 (nowy kod) XXXX - zapisanie nowego kou nr 01
;0# - wyjscie z instalacji

;definiowanie zmiennych
#define IN_PROG GPIO, 1			;programowanie <=> 0
#define ADC GPIO, 0			;wejscie przetwornika ADC
#define OUT2 GPIO, 2			;
#define OUT1 GPIO, 4			;przekaxnik
#define BUZER_OUT GPIO, 5		;wyjscie BUZERA

#define dph 20h				; starszy bajt pomocniczy
#define dpl 21h				; mlodszy bajt pomocniczy
#define licznik h'22'			; pomocniczy licznik petli opoznienia
#define data_rd h'23'			; przepisanie danej z eeprom
#define stos h'24'			; pomocniczy rejestr zapamietujacy zmienne jak stos
#define key_cod h'25'			; kod klawiatury FF=nie byl nacisniety klaisz
#define F_data h'26'			; rej. przechowujacy zawartosc przeladowania timera
#define adress h'27'			;adres eeprom


;deklaracj typu procesora i formatu liczb
	list p=12F675			;okreslenie typu procesora
	#include p12f675.inc	;dolaczenie pliku z nazwami

;konfiguracja procesora
	__config _INTRC_OSC_NOCLKOUT &_MCLRE_ON &_WDT_OFF; gen wew. RC bez wyjscia 
									;wlaczone wejscie reset
									;watch dog wylaczony
	org 0
	goto start
	
	org 4
	goto timer_int	; (2CM)
start

;wylacz komparator
	movlw .7
	movwf cmcon

;konfiguracja linii i/o
	bsf status, rp0;bank1

	movlw h'0b'					;0000 1011   0=wyjscie, 1=wejscie
	movwf trisio
	movlw h'36'					;0011 0110 rezystor pull up GP5 - prog
	movwf wpu
	bcf option_reg, 7				;zalacza wybrane w wpu rezystory do Vdd
							;GPPU=0 w rej option_reg 7 bit zalacza rezustory z rej. wpu
	bcf status, rp0 ;bank0

;wlacz adc
	;konfiguracja wejscia
	bsf status, rp0 ;bank1
	movlw b'11110000'	;	czestotliwo tj. RC, wejcie ANS1
	movwf ansel

	bcf status, rp0 ;bank0

	movlw b'00110001'	;	just - lewo; Vref=Vdd; ch0; ADC on
	movwf adcon0

	bcf intcon, gie	; zablokuj przerwania
	bcf pir1, adif	;zeruj flage przerwania

;ustawienia przerwania od timera0
	bsf status, rp0	;bank1
	movlw b'00000100'	;zliczanie cykli zegarowych bez preskalera
	movwf option_reg
	bcf status, rp0	;bank0
	clrf intcon
	clrf tmr0	;zeruje timer0 i preskaler
	bcf intcon, t0ie	;zezwolenie na int od timer0
	bsf intcon, gie	;ogolny bit zezwolenia na przerwania off
	bsf BUZER_OUT

;********************************************************
;program glowy

	bcf status, rp0	;bank0
	bsf intcon, gie	;ogolny bit zezwolenia na przerwania off
	movlw .250	
	movwf F_data
	movwf tmr0
MENU0
	bsf OUT2
	bcf OUT1
;	call BUZER
;	call BUZER
;	call BUZER
MENU
	call KEY_RD	
	incf key_cod, 0	;
	btfsc status, z	;
	goto MENU

	movf key_cod, 0	;W=key_cod
	sublw h'0a'		;w=w-10
	btfss status, z	;jesli W=0 =>skok
	goto MENU19		;czy klaiwsz=1?
	clrf adress	;zerowanie licznika
MENU1
	call KEY_RD	
	incf key_cod, 0	;
	btfsc status, z	;
	goto MENU1
	movf key_cod, 0	;W=key_cod
	sublw h'0a'		;w=w-10
	btfss status, z	;jesli W=0 =>skok
	goto MENU10		;czy klaiwsz=1-9?
	clrw
	movwf key_cod
	goto MENU11
MENU10
	movf key_cod, 0	;W=key_cod
	sublw h'0b'		;w=w-11
	btfsc status, z	;jesli W<>*>skok
	goto MENU_F4A		;czy klaiwsz=*
	movf key_cod, 0	;W=key_cod
	sublw h'0c'		;w=w-12
	btfsc status, z	;jesli W<>=>skok
	goto MENU_F4A		;czy klaiwsz=*
MENU11			;dwie cyfry nr kodu bez * i #
	movf key_cod, 0	;W=key_cod
	addwf adress, 0	;W=W+licznik =>adres
	clrf adress
	call ADR_INC
	movf adress, 0	;W:=ADRESS
	call eeprom_read	;W=eeprom(W)
	movwf data_rd		;data_rd=eeprom(w)
MENU12
	call KEY_RD	
	incf key_cod, 0	;
	btfsc status, z	;
	goto MENU12
	movf data_rd, 0
	subwf key_cod, 0
	btfss status, z	;jesli W<>*>skok
	goto MENU_F2	;blad w pierwszej cyfrze
	incf adress, 0	;inc adres
	movwf adress	;licznik:=W
	call eeprom_read	;W=eeprom(W)
	movwf data_rd		;data_rd=eeprom(w)
MENU13
	call KEY_RD	
	incf key_cod, 0	;
	btfsc status, z	;
	goto MENU13
	movf data_rd, 0
	subwf key_cod, 0
	btfss status, z	;jesli W<>*>skok
	goto MENU_F3	;blad w drugiej cyfrze
	incf adress, 0	;inc adres
	movwf adress	;licznik:=W
	call eeprom_read	;W=eeprom(W)
	movwf data_rd	;data_rd=eeprom(w)
MENU14
	call KEY_RD	
	incf key_cod, 0	;
	btfsc status, z	;
	goto MENU14
	movf data_rd, 0
	subwf key_cod, 0
	btfss status, z	;jesli W<>*>skok
	goto MENU_F4	;blad w trzeiej cyfrze
	incf adress, 0	;inc adres
	movwf adress	;licznik:=W
	call eeprom_read	;W=eeprom(W)
	movwf data_rd	;data_rd=eeprom(w)
MENU15
	call KEY_RD	
	incf key_cod, 0	;
	btfsc status, z	;
	goto MENU15
	movf data_rd, 0
	subwf key_cod, 0
	btfss status, z	;jesli W<>*>skok
	goto MENU_F4A	;blad w trzeiej cyfrze
	goto MENU2		;KOD OK
MENU_F2		;blad po DRUGIM klaiszu oczekuje na pozostale 2
	call KEY_RD	
	incf key_cod, 0	;
	btfsc status, z	;
	goto MENU_F2
MENU_F3		;blad po TRZECIM klaiszu oczekuje na pozostalY 1
	call KEY_RD	
	incf key_cod, 0	;
	btfsc status, z	;
	goto MENU_F3
MENU_F4		;blad po TRZECIM klaiszu oczekuje na pozostalY 1
	call KEY_RD	
	incf key_cod, 0	;
	btfsc status, z	;
	goto MENU_F4
MENU_F4A
	call BUZER_LONG
	goto MENU
MENU19			;czy klawisz bylk jedynka
	movf key_cod, 0	;W=key_cod
	sublw h'01'		;w=w-1
	btfsc status, z	;jesli W<>*>skok
	goto MENU19A	;czy klaiwsz=*
	movf key_cod, 0	;W=key_cod
	sublw h'02'		;w=w-2
	btfss status, z	;jesli W<>=>skok
	goto MENU_F4A		;czy klaiwsz=*
	movlw h'14'
	movwf adress
	goto MENU1
MENU19A
	movlw h'0A'
	movwf adress
	goto MENU1
MENU2
	call BUZER			; KOD OK
	call BUZER
;	call BUZER
	bsf OUT1			;aktywne wyjscie
	bcf OUT2	;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
			;wykrywanie kodu instalatora adress=03h
	movf adress, 0	;W=adress
	sublw h'03'		;w=w-3
	btfsc status, z	;
	goto MENU3	;
	movlw h'7e'
	call eeprom_read
	movwf data_rd
	movlw h'7d'
	call eeprom_write
	movlw h'7f'
	call eeprom_read
	movwf data_rd
	movlw h'7e'
	call eeprom_write
	movf adress, 0
	movwf data_rd
	movlw h'7f'
	call eeprom_write
MENU2A
	movlw h'14'
	movwf data_rd
MENU21
	call delay10
	incf data_rd, 0
	movwf data_rd
	btfss status, z
	goto MENU21A
	call BUZER
	movlw h'50'
	movwf data_rd
MENU21A
	call KEY_RD	
	movf key_cod, 0	;W=key_cod
	sublw h'0a'		;w=w-10
	btfss status, z	;jesli W=0 =>skok
	goto MENU21		;klaiwsz <>0
MENU21B
	call BUZER
	call KEY_RD	
	movf key_cod, 0	;W=key_cod
	sublw h'0C'		;w=w-12
	btfss status, z	;jesli W=0 =>skok
	goto MENU21B		;klaiwsz <>#
	goto MENU0		;uzbrojenie
MENU3				;instalator
	call BUZER_LONG
MENU3A
	call KEY_RD	
	incf key_cod, 0	;
	btfsc status, z	;
	goto MENU3A
	movf key_cod, 0	;W=key_cod
	sublw h'0b'		;w=w-11
	btfss status, z	;jesli W=0 =>skok
	goto MENU5
MENU4				;odczyt 3 ostatnik rozbrojen
	call delay1s
	movlw h'7f'
	call eeprom_read
	movwf adress
	call ADR_RD
	call delay1s
	movlw h'7e'
	call eeprom_read
	movwf adress
	call ADR_RD
	call delay1s
	movlw h'7d'
	call eeprom_read
	movwf adress
	call ADR_RD
	call delay1s
	goto MENU2A
MENU5				;wpisywanie nowych kodw
	movf key_cod, 0	;W=key_cod
	sublw h'0c'		;w=w-11
	btfss status, z	;jesli W=0 =>skok
	goto MENU2A
MENU5A
	call KEY_RD	
	incf key_cod, 0	;
	btfsc status, z	;
	goto MENU5A
	movf key_cod, 0	;W=key_cod
	sublw h'0a'		;w=w-10
	btfss status, z	;jesli W=0 =>skok
	goto MENU6		;czy klaiwsz=1? !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	clrf adress	;zerowanie licznika
MENU5B
	call KEY_RD	
	incf key_cod, 0	;
	btfsc status, z	;
	goto MENU5B
	movf key_cod, 0	;W=key_cod
	sublw h'0a'		;w=w-10
	btfss status, z	;jesli W=0 =>skok
	goto MENU5C		;czy klaiwsz=1-9?
	;clrf adress	;zerowanie licznika
	clrw
	movwf key_cod
	goto MENU5D
MENU5C
	movf key_cod, 0	;W=key_cod
	sublw h'0b'		;w=w-11
	btfsc status, z	;jesli W<>*>skok
	goto MENU_F4A		;czy klaiwsz=*
	movf key_cod, 0	;W=key_cod
	sublw h'0c'		;w=w-12
	btfsc status, z	;jesli W<>=>skok
	goto MENU_F4A		;czy klaiwsz=*
MENU5D			;dwie cyfry nr kodu bez * i #
	movf key_cod, 0	;W=key_cod
	addwf adress, 0	;W=W+licznik =>adres
	clrf adress
	call ADR_INC
MENU5E
	call KEY_RD	
	incf key_cod, 0	;
	btfsc status, z	;
	goto MENU5E
	movf key_cod, 0
	movwf data_rd		;data_rd=eeprom(w)
	movf adress, 0
	call eeprom_write
	incf adress, 0
	movwf adress
MENU5F
	call KEY_RD	
	incf key_cod, 0	;
	btfsc status, z	;
	goto MENU5F
	movf key_cod, 0
	movwf data_rd		;data_rd=eeprom(w)
	movf adress, 0
	call eeprom_write
	incf adress, 0
	movwf adress
MENU5G
	call KEY_RD	
	incf key_cod, 0	;
	btfsc status, z	;
	goto MENU5G
	movf key_cod, 0
	movwf data_rd		;data_rd=eeprom(w)
	movf adress, 0
	call eeprom_write
	incf adress, 0
	movwf adress
MENU5H
	call KEY_RD	
	incf key_cod, 0	;
	btfsc status, z	;
	goto MENU5H
	movf key_cod, 0
	movwf data_rd		;data_rd=eeprom(w)
	movf adress, 0
	call eeprom_write
	call BUZER
;	call BUZER
	goto MENU2A
MENU6
	movf key_cod, 0	;W=key_cod
	sublw h'01'		;w=w-1
	btfsc status, z	;jesli W<>*>skok
	goto MENU6A	;czy klaiwsz=*
	movf key_cod, 0	;W=key_cod
	sublw h'02'		;w=w-2
	btfss status, z	;jesli W<>=>skok
	goto MENU5A		;MENU6B		;czy klaiwsz=*
	movlw h'14'
	movwf adress
	goto MENU5B
MENU6A
	movlw h'0A'
	movwf adress
	goto MENU5B
;MENU6B
;	call BUZER_LONG
;	goto MENU5A
;********************************************************
; funkcje pomocnicze
;obsluga przerwania od timera0
timer_int
	movwf stos; zapamietanie wartosci W
	bcf status, rp0	;bank0			(1CM)	
	bcf intcon, t0if	;zeruje flage przerwania (1CM)
	movf F_data, 0
	movwf tmr0	;	poczatkowa wartosc 204 + 2cykle na zaladowanie tmr0 (1CM)
	btfss BUZER_OUT	; jesli najstarszy bit konwersji ADC.1=0 omin instr
	goto timer_int1
	bcf BUZER_OUT
	goto timer_int_end
timer_int1
	bsf BUZER_OUT
timer_int_end
	movf stos, 0; W:=stos zwrot wartosci W
	retfie						;(2CM)

;opoznienie o 10 ms
delay10
	movlw h'0b'		;1 bylo 0bh
delay10a
	movwf dph		;1
	movlw h'f2'		;1
delay10b
	movwf dpl	;przepisuja W do dpl
	decfsz dpl,0		;1 dekrement, wynik do W, jesli 0 pomin next instr.
	goto delay10b	;1
	movlw dph	;	wpisz do W dph
	decfsz dph,0	;1 zmniejsz dph, wynik do W, jesli 0 pomin next instr.
	goto delay10a	;1
	return	
;opoznienie o 100ms
delay100ms
	movwf stos 	;zapamietuje W na stosie
	movlw .10
	movwf licznik
	call delay10
	decfsz licznik, f
	goto $-2
	movf stos,0	;oddaje wartosc W
	return
;opoznienie o 1 sek
delay1s
	movwf stos 	;zapamietuje W na stosie
	movlw .100
	movwf licznik
	call delay10
	decfsz licznik, f
	goto $-2
	movf stos,0	;oddaje wartosc W
	return
;odczyt z eeprom spod adr. W, dana zapisana do W
eeprom_read
	bsf status, rp0 ;bank1
	movwf eeadr		;wpisanie adresu z w eeadr
	bsf eecon1, rd	;odczyt z eeprom
	movf eedata, w	;przepisanie odczytanej danej do w
	bcf status, rp0 ;bank0
	return
;zapis do eeprom spod adresu W (dane data_rd)
eeprom_write
	;movwf data_rd	;przepisanie dnych z W do DATA_RD
				;zapis nowych danych do eeprom pod adr. 0
	bsf status, rp0 ;bank1
	;clrw			;w:=0 dres
	movwf eeadr		;wpisanie adresu z w eeadr
	movf data_rd, 0	;dane do zapisu wyslane do W
	movwf eedata	;wyslanie danych do eedata
	bsf eecon1, wren	;zezwolenie na zapis
	movlw h'55'
	movwf eecon2
	movlw h'aa'
	movwf eecon2
	bsf eecon1, wr	;rozpoczecie zapisu
	btfsc eecon1, wr	;oczekiwanie na koniec zapisu
	goto $-1
	bcf eecon1, wren	;wyl. zezwolenia na zapis
	bcf status, rp0	;powrot do bank0
	return

;jednokrotny sygnal dzwiekowy
BUZER
	bcf status, rp0
	bsf intcon, t0ie	;zezwolenie na int od timer0
	call delay100ms
	bsf BUZER_OUT
	bcf intcon, t0ie	;zezwolenie na int od timer0
	call delay100ms
	return
;jednokrotny sygnal dzwiekowy
BUZER_LONG
	bcf status, rp0
	bsf intcon, t0ie	;zezwolenie na int od timer0
	call delay100ms
	call delay100ms
	call delay100ms
	bsf BUZER_OUT
	bcf intcon, t0ie	;zezwolenie na int od timer0
	call delay100ms
	return
;odczyt klawiszy
KEY_RD
	bcf status, rp0
	bsf adcon0, go	; start konwersji ADC
	btfsc adcon0, go	; czy koniec konwersji
	goto $-1
	btfss adresh, 7	
	goto KEY_RD0
	btfss adresh, 6
	goto KEY_RD0
	movlw h'ff'	;key-cod - brak nacisniecia klawisza
	movwf key_cod
	goto KEY_RD_END
KEY_RD0
	call delay10
	bcf status, rp0
	bsf adcon0, go	; start konwersji ADC
	btfsc adcon0, go	; czy koniec konwersji
	goto $-1
	incf adresh, 0
	movwf dpl		;przepisuja W do dpl
	decf dpl, 0
	btfss status, z
	goto KEY_RD1
	movlw h'0c'	;key-cod - #
	movwf key_cod
	goto KEY_RD1C
KEY_RD1
	movlw h'ff'	;key-cod - brak nacisniecia klawisza
	movwf key_cod
	movf adresh, 0
	addlw h'7e'
	btfss status, c	;
	goto KEY_RD11
	movlw h'02'	;key-cod - 2
	movwf key_cod
	goto KEY_RD1C
KEY_RD11
	movf adresh, 0
	addlw h'88'
	btfss status, c	;
	goto KEY_RD12
	movlw h'05'	;key-cod - 5
	movwf key_cod
	goto KEY_RD1C
KEY_RD12
	movf adresh, 0
	addlw h'8e'
	btfss status, c	;
	goto KEY_RD13
	movlw h'08'	;key-cod - 8
	movwf key_cod
	goto KEY_RD1C
KEY_RD13
	movf adresh, 0
	addlw h'9c'
	btfss status, c	;
	goto KEY_RD14
	movlw h'0a'	;key-cod - 0
	movwf key_cod
	goto KEY_RD1C
KEY_RD14
	movf adresh, 0
	addlw h'aa'
	btfss status, c	;
	goto KEY_RD15
	movlw h'01'	;key-cod - 1
	movwf key_cod
	goto KEY_RD1C
KEY_RD15
	movf adresh, 0
	addlw h'b8'
	btfss status, c	;
	goto KEY_RD16
	movlw h'03'	;key-cod - 3
	movwf key_cod
	goto KEY_RD1C
KEY_RD16
	movf adresh, 0
	addlw h'bf'
	btfss status, c	;
	goto KEY_RD17
	movlw h'04'	;key-cod - 4
	movwf key_cod
	goto KEY_RD1C
KEY_RD17
	movf adresh, 0
	addlw h'ca'
	btfss status, c	;
	goto KEY_RD18
	movlw h'07'	;key-cod - 7
	movwf key_cod
	goto KEY_RD1C
KEY_RD18
	movf adresh, 0
	addlw h'd7'
	btfss status, c	;
	goto KEY_RD19
	movlw h'0b'	;key-cod - *
	movwf key_cod
	goto KEY_RD1C
KEY_RD19
	movf adresh, 0
	addlw h'e6'
	btfss status, c	;
	goto KEY_RD20
	movlw h'06'	;key-cod - 6
	movwf key_cod
	goto KEY_RD1C
KEY_RD20
	movf adresh, 0
	addlw h'f5'
	btfss status, c	;
	goto KEY_RD2
	movlw h'09'	;key-cod - 9
	movwf key_cod
KEY_RD1c
	call BUZER	;sygnal dzwiekowy
KEY_RD2
	call delay10
	bsf adcon0, go	; start konwersji ADC
	btfsc adcon0, go	; czy koniec konwersji
	goto $-1
	btfsc adresh, 7
;	goto KEY_RD2	;oczekuje na puszczenie klawisza
	btfss adresh, 6
	goto KEY_RD2	;oczekuje na puszczenie klawisza
KEY_RD_END
	return
;****************************************************************************
;funkcja zwiekszajaca o 4 adres eprom tyle razy ile jest W > adres=W(adres+4)
ADR_INC
	movwf dpl	;dpl=W
	movlw h'04'
	addwf adress, 0
	movwf adress
	decf	dpl, 0
	btfss status, z
	goto ADR_INC
	return

ADR_RD
	movlw h'03'
	subwf adress, 0
ADR_RD1
	movwf adress
	call BUZER
	call delay100ms
	call delay100ms
	call delay100ms
	movlw h'04'
	subwf adress, 0
	btfss status, z
	goto ADR_RD1
	return
;***************************************************************************
	end
